<?php
include 'config.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name  = $_POST['name'];
    $email = $_POST['email'];
    $role  = $_POST['role'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $stmt = $conn->prepare("INSERT INTO users (name,email,password,role) VALUES (?,?,?,?)");
    $stmt->bind_param("ssss", $name, $email, $password, $role);
    $stmt->execute();

    header("Location: users.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head><title>Create User</title></head>
<body>
    <h1>Create User</h1>
    <form method="post">
        <input type="text" name="name" placeholder="Full Name" required><br>
        <input type="email" name="email" placeholder="Email" required><br>
        <input type="password" name="password" placeholder="Password" required><br>
        <select name="role">
            <option value="employee">Employee</option>
            <option value="trainer">Trainer</option>
            <option value="admin">Admin</option>
        </select><br>
        <button type="submit">Save</button>
    </form>
</body>
</html>
